/***********************************************************************/
/*                                                                     */
/*  FILE        :oszi_15.c                                             */
/*  DATE        :Wed, Oct 26, 2005                                     */
/*  DESCRIPTION :Main Program                                          */
/*  CPU TYPE    :Other                                                 */
/*                                                                     */
/*  This file is generated by Renesas Project Generator (Ver.4.0).     */
/*                                                                     */
/*  Einkanal-Scope, R8C/15, 10 MHz, 19200 Baud, 10 Bit, 250 Messungen  */
/*                                                                     */
/***********************************************************************/
                  


#include "sfr_r815.h";                  

unsigned int ad_buf[250];


/************************************************************************************
Name:        sfr_init
Parameters:  None
Returns:     None
Description: Initial setting of SFR registers
************************************************************************************/
void sfr_init(void){
    /* Setting port registers */
    p1 = p1 | 0x10;                         /* TxD0 port output */

    /* Setting port direction registers */
    pd1 = pd1 | 0x10;                       /* TxD0 port direction = output */
    pd1 = pd1 & 0xdf;                       /* RxD0 port direction = input */

    /* Clock synchronous serial I/O setting */
    u0mr = 0x05;                            /* Setting UART0 transmit/receive mode register */
    u0c0 = 0x00;                            /* Setting UART0 transmit/receive control register 0 */
    u0rrm = 0;                              /* Continuous receive mode disabled */
    u0brg = 32-1;                           /* Setting UART0 baud rate generator */
                                            /* (Approx. 19200bps @20MHz,f1) */
    re_u0c1 = 1;                            /* Reception enabled */
}

void sendTxd0(unsigned char data)
{
	while (ti_u0c1 == 0);	//Wait for transmission buffer emty
	u0tbl = data;       	// Set transmission data 
    te_u0c1 = 1;        	// Transmission enabled 
}

unsigned char receiveRxd0 (void)
{
	unsigned char data;
	unsigned char dummy;
	while (ir_s0ric == 0); 	//Wait for received data
    ir_s0ric = 0;    		//Clear serial reception flag 
	data = u0rbl;     		// Get reception data 
	dummy = u0rbh;     		// Get error 
	re_u0c1 = 1;      		// Reception enabled 
	return data;
}

unsigned int ad_in(unsigned char ch)
{
    /* Set A/D control registers */
    adcon0 = 0x94 + ch;      				//ADN8...AN11 an P1_0...P1_3               /* Analog input pin : AN0 is selected */
    adcon1 = 0x28;                          /* 10-bit mode */
    adst = 1;                               /* Conversion start */
    while(adst == 1){}                      /* Wait A/D conversion */
    return ad;                   /* return AD value */
}

void messung(void)
{
	unsigned int adr;
	for (adr = 0; adr < 250; adr++)
	{
		ad_buf[adr] = ad_in(0);
	}	 
	for (adr = 0; adr < 250; adr++)
	{
		sendTxd0(ad_buf[adr] >> 8);
		//delayus (2000);
		sendTxd0(ad_buf[adr] & 0xff);
		//delayus (2000);
	}	 
}

void main(void)
{
    /*-------------------------------------------------
    -  Change on-chip oscillator clock to Main clock  -
    -------------------------------------------------*/

    prc0 = 1;           	/* Protect off */
    cm13 = 1;           	/* Xin Xout */
    cm15 = 1;           	/* XCIN-XCOUT drive capacity select bit : HIGH */
    cm05 = 0;           	/* Xin on */
    cm16 = 0;           	/* Main clock = No division mode */
    cm17 = 0;
    cm06 = 0;           	/* CM16 and CM17 enable */
    asm("nop");         	/* Waiting for stable of oscillation */
    asm("nop");
    asm("nop");
    asm("nop");
    ocd2 = 0;           	/* Main clock change */
    prc0 = 0;           	/* Protect on */
	sfr_init();  

	while (1)
	{  
		receiveRxd0();
		messung();
	}
}

