;************************************************************************************
;*																					*
;*  file name   : SFR_R815.inc														*
;*  Contents    : definition of R8C/14 & R8C/15 Group SFR							*
;*																					*
;*  Copyright, 2004 RENESAS TECHNOLOGY CORPORATION									*
;*                  AND RENESAS SOLUTIONS CORPORATION								*
;*																					*
;*  Version     : 1.01 (04-07-29)                                                   *
;*                     correct comment fmr46                                        *
;*																					*
;*																					*
;************************************************************************************
;
;-------------------------------------------------------
;   Processor mode register0
;-------------------------------------------------------
pm0				.equ		0004h
;
pm03			.btequ		3,pm0		; Software reset bit
;
;-------------------------------------------------------
;   Processor mode register1
;-------------------------------------------------------
pm1				.equ		0005h
;
pm12			.btequ		2,pm1		; WDT interrupt/reset select bit
;
;-------------------------------------------------------
;   System clock control register0
;-------------------------------------------------------
cm0				.equ		0006h
;
cm02			.btequ		2,cm0		; WAIT peripheral function clock stop bit
cm05			.btequ		5,cm0		; Main clock (Xin-Xout) stop bit
cm06			.btequ		6,cm0		; Main clock division select bit0
;
;-------------------------------------------------------
;   System clock control register1
;-------------------------------------------------------
cm1				.equ		0007h
;	
cm10			.btequ		0,cm1		; All clock stop control bit
cm13			.btequ		3,cm1		; Port Xin-Xout switch bit
cm14			.btequ		4,cm1		; Low-speed on-chip oscillator stop bit
cm15			.btequ		5,cm1		; Xin-Xout drive capability select bit
cm16			.btequ		6,cm1		; Main clock division select bit1
cm17			.btequ		7,cm1		;
;
;-------------------------------------------------------
;   Address match interrupt enable register
;-------------------------------------------------------
aier			.equ		0009h
;
aier0			.btequ		0,aier		; Address match interrupt 0 enable bit
aier1			.btequ		1,aier		; Address match interrupt 1 enable bit
;
;-------------------------------------------------------
;   Protect register
;-------------------------------------------------------
prcr			.equ		000ah
;
prc0			.btequ		0,prcr		; Protect bit0
prc1			.btequ		1,prcr		; Protect bit1
prc3			.btequ		3,prcr		; Protect bit3;
;
;-------------------------------------------------------
;   Oscillation stop detection register
;-------------------------------------------------------
ocd				.equ		000ch
;
ocd0			.btequ		0,ocd		; Oscillation stop detection enable bit
ocd1			.btequ		1,ocd		;
ocd2			.btequ		2,ocd		; System clock select bit
ocd3			.btequ		3,ocd		; Clock monitor bit
;
;-------------------------------------------------------
;   Watchdog timer
;-------------------------------------------------------
wdtr			.equ		000dh		; Watchdog timer reset register
;
wdts			.equ		000eh		; Watchdog timer start register
;
wdc				.equ		000fh		; Watchdog timer control register
;
wdc7			.btequ		7,wdc		; Prescaler select bit
;
;-------------------------------------------------------
;   Address match interrupt register0
;-------------------------------------------------------
rmad0			.equ		0010h
rmad0l			.equ		rmad0		; Address match interrupt register0 Low
rmad0m			.equ		rmad0+1		; Address match interrupt register0 Middle
rmad0h			.equ		rmad0+2		; Address match interrupt register0 High
;
;-------------------------------------------------------
;   Address match interrupt register1
;-------------------------------------------------------
rmad1			.equ		0014h
rmad1l			.equ		rmad1		; Address match interrupt register1 Low
rmad1m			.equ		rmad1+1		; Address match interrupt register1 Middle
rmad1h			.equ		rmad1+2		; Address match interrupt register1 High
;
;-------------------------------------------------------
;   Count source protect mode register
;-------------------------------------------------------
cspr			.equ		001ch
;
cspro			.btequ		7,cspr		; WDT count source protect mode select bit
;
;-------------------------------------------------------
;   INT0 input filter select register
;-------------------------------------------------------
int0f			.equ		001eh
;
int0f0			.btequ		0,int0f		; INT0 input filter select bit
int0f1			.btequ		1,int0f		;
;
;;-------------------------------------------------------
;   High speed on-chip oscillator A control register0
;-------------------------------------------------------
hra0			.equ		0020h
;
hra00			.btequ		0,hra0		; High speed on-chip oscillator A enable bit
hra01			.btequ		1,hra0		; High speed on-chip oscillator A select bit
;
;-------------------------------------------------------
;   High speed on-chip oscillator A control register1
;-------------------------------------------------------
hra1			.equ		0021h
;
;-------------------------------------------------------
;   High speed on-chip oscillator A control register2
;-------------------------------------------------------
hra2			.equ		0022h
;
hra20			.btequ		0,hra2		; High speed on-chip oscillator moed select bit
hra21			.btequ		1,hra2		; High speed on-chip oscillator moed select bit
;
;-------------------------------------------------------
;   Voltage detection A register1
;-------------------------------------------------------
vca1			.equ		0031h
;
vca13			.btequ		3,vca1		; Voltage detection 2 signal monitor flag
;
;-------------------------------------------------------
;   Voltage detection A register2
;-------------------------------------------------------
vca2			.equ		0032h
;
vca26			.btequ		6,vca2		; Voltage enable bit
vca27			.btequ		7,vca2		; Voltage enable bit
;
;-------------------------------------------------------
;   Voltage monitor 1 circuit control register
;-------------------------------------------------------
vw1c			.equ		0036h
;
vw1c0			.btequ		0,vw1c		; Voltage monitor 1 reset enable bit
vw1c1			.btequ		1,vw1c		; Voltage Monitor 1 digital filter disable mode select bit
vw1c2			.btequ		2,vw1c		; Voltage change detection flag
vw1c3			.btequ		3,vw1c		; Voltage detection 1 signal monitor flag
vw1f0			.btequ		4,vw1c		; Sampling clock select bit
vw1f1			.btequ		5,vw1c		; Sampling clock select bit
vw1c6			.btequ		6,vw1c		; Voltage monitor 1 circuit mode select bit
vw1c7			.btequ		7,vw1c		; Voltage monitor 1 reset generating condition select bit
;
;-------------------------------------------------------
;   Voltage monitor 2 circuit control register
;-------------------------------------------------------
vw2c			.equ		0037h

vw2c0			.btequ		0,vw2c		; Voltage monitor 2 interrupt / reset enable bit
vw2c1			.btequ		1,vw2c		; Voltage monitor 2 digital filter disabled mode select bit
vw2c2			.btequ		2,vw2c		; Voltage change detection flag
vw2c3			.btequ		3,vw2c		; WDT Detection Flag
vw2f0			.btequ		4,vw2c		; Sampling clock select bit
vw2f1			.btequ		5,vw2c		; Sampling clock select bit
vw2c6			.btequ		6,vw2c		; Voltage monitor 2 circuit mode select bit
vw2c7			.btequ		7,vw2c		; Voltage monitor 2 interrupt / reset generating condition select bit
;                                     
;-------------------------------------------------------
;   Interrupt control registers
;-------------------------------------------------------
kupic			.equ		004dh		; Key input interrupt control register
ilvl0_kupic		.btequ		0,kupic		; Interrupt priority level select bit
ilvl1_kupic		.btequ		1,kupic		;
ilvl2_kupic		.btequ		2,kupic		;
ir_kupic		.btequ		3,kupic		; Interrupt request bit
;
adic			.equ		004eh		; A-D conversion interrupt control register
ilvl0_adic		.btequ		0,adic		; Interrupt priority level select bit
ilvl1_adic		.btequ		1,adic		;
ilvl2_adic		.btequ		2,adic		;
ir_adic			.btequ		3,adic		; Interrupt request bit
;
ssuaic			.equ		004fh		; SSUA interrupt control register
ilvl0_ssuaic	.btequ		0,ssuaic	; Interrupt priority level select bit
ilvl1_ssuaic	.btequ		1,ssuaic	;
ilvl2_ssuaic	.btequ		2,ssuaic	;
ir_ssuaic		.btequ		3,ssuaic	; Interrupt request bit
;
cmp1ic			.equ		0050h		; Compare 1 interrupt control register
ilvl0_cmp1ic	.btequ		0,cmp1ic	; Interrupt priority level select bit
ilvl1_cmp1ic	.btequ		1,cmp1ic	;
ilvl2_cmp1ic	.btequ		2,cmp1ic	;
ir_cmp1ic		.btequ		3,cmp1ic	; Interrupt request bit
;
s0tic			.equ		0051h		; UART0 transmit interrupt control register
ilvl0_s0tic		.btequ		0,s0tic		; Interrupt priority level select bit
ilvl1_s0tic		.btequ		1,s0tic		;
ilvl2_s0tic		.btequ		2,s0tic		;
ir_s0tic		.btequ		3,s0tic		; Interrupt request bit
;
s0ric			.equ		0052h		; UART0 receive interrupt control register
ilvl0_s0ric		.btequ		0,s0ric		; Interrupt priority level select bit
ilvl1_s0ric		.btequ		1,s0ric		;
ilvl2_s0ric		.btequ		2,s0ric		;
ir_s0ric		.btequ		3,s0ric		; Interrupt request bit
;
txic			.equ		0056h		; Timer X interrupt control register
ilvl0_txic		.btequ		0,txic		; Interrupt priority level select bit
ilvl1_txic		.btequ		1,txic		;
ilvl2_txic		.btequ		2,txic		;
ir_txic			.btequ		3,txic		; Interrupt request bit
;
tzic			.equ		0058h		; Timer Z interrupt control register
ilvl0_tzic		.btequ		0,tzic		; Interrupt priority level select bit
ilvl1_tzic		.btequ		1,tzic		;
ilvl2_tzic		.btequ		2,tzic		;
ir_tzic			.btequ		3,tzic		; Interrupt request bit
;
int1ic			.equ		0059h		; INT1 interrupt control register
ilvl0_int1ic	.btequ		0,int1ic	; Interrupt priority level select bit
ilvl1_int1ic	.btequ		1,int1ic	;
ilvl2_int1ic	.btequ		2,int1ic	;
ir_int1ic		.btequ		3,int1ic	; Interrupt request bit
;
int3ic			.equ		005ah		; INT3 interrupt control register
ilvl0_int3ic	.btequ		0,int3ic	; Interrupt priority level select bit
ilvl1_int3ic	.btequ		1,int3ic	;
ilvl2_int3ic	.btequ		2,int3ic	;
ir_int3ic		.btequ		3,int3ic	; Interrupt request bit
;
tcic			.equ		005bh		; Timer C interrupt control register
ilvl0_tcic		.btequ		0,tcic		; Interrupt priority level select bit
ilvl1_tcic		.btequ		1,tcic		;
ilvl2_tcic		.btequ		2,tcic		;
ir_tcic			.btequ		3,tcic		; Interrupt request bit
;
cmp0ic			.equ		005ch		; Compare 0 interrupt control register
ilvl0_cmp0ic	.btequ		0,cmp0ic	; Interrupt priority level select bit
ilvl1_cmp0ic	.btequ		1,cmp0ic	;
ilvl2_cmp0ic	.btequ		2,cmp0ic	;
ir_cmp0ic		.btequ		3,cmp0ic	; Interrupt request bit
;
int0ic			.equ		005dh		; INT0 interrupt control register
ilvl0_int0ic	.btequ		0,int0ic	; Interrupt priority level select bit
ilvl1_int0ic	.btequ		1,int0ic	;
ilvl2_int0ic	.btequ		2,int0ic	;
ir_int0ic		.btequ		3,int0ic	; Interrupt request bit
pol_int0ic		.btequ		4,int0ic	; Polarity select bit
;
;-------------------------------------------------------
;   Timer Z mode register
;-------------------------------------------------------
tyzmr			.equ		0080h
tzmr			.equ		0080h
;
tzmod0			.btequ		4,tzmr		; Timer Z operation mode bit
tzmod1			.btequ		5,tzmr		;
tzwc			.btequ		6,tzmr		; Timer Z write control bit
tzs				.btequ		7,tzmr		; Timer Z count start flag
;
;-------------------------------------------------------
;   Timer Z waveform output control register
;-------------------------------------------------------
pum				.equ		0084h
;
tzopl			.btequ		5,pum		; Timer Z output level latch
inostg			.btequ		6,pum		; INT0 pin one-shot trigger control bit
inoseg			.btequ		7,pum		; INT0 pin one-shot trigger polarity select bit
;
;-------------------------------------------------------
;   Timer Z registers
;-------------------------------------------------------
prez			.equ		0085h		; Prescaler Z register
;
tzsc			.equ		0086h		; Timer Z secondary register
;
tzpr			.equ		0087h		; Timer Z primary register
;
;-------------------------------------------------------
;   Timer Z output control register
;-------------------------------------------------------
tyzoc			.equ		008ah
tzoc			.equ		008ah
;
tzos			.btequ		0,tzoc		; Timer Z one-shot start bit
tzocnt			.btequ		2,tzoc		; Timer Z programmable waveform generation output switching bit
;
;-------------------------------------------------------
;   Timer X mode register
;-------------------------------------------------------
txmr			.equ		008bh
;
txmod0			.btequ		0,txmr		; Operation mode select bit0
txmod1			.btequ		1,txmr		; Operation mode select bit1
r0edg			.btequ		2,txmr		; INT1/CNTR0 polarity switching bit
txs				.btequ		3,txmr		; Timer X count start flag
txocnt			.btequ		4,txmr		; P30/CNTR0 select bit
txmod2			.btequ		5,txmr		; Operation mode select bit2
txedg			.btequ		6,txmr		; Active edge reception flag
txund			.btequ		7,txmr		; Timer X under flow flag
;
;-------------------------------------------------------
;   Timer X registers
;-------------------------------------------------------
prex			.equ		008ch		; Prescaler X register
;
tx				.equ		008dh		; Timer X register
;
;-------------------------------------------------------
;   Timer count source setting register
;-------------------------------------------------------
tcss			.equ		008eh
;
txck0			.btequ		0,tcss		; Timer X count source select bit
txck1			.btequ		1,tcss		;
tzck0			.btequ		4,tcss		; Timer Z count source select bit
tzck1			.btequ		5,tcss		;
;
;-------------------------------------------------------
;   Timer C registers
;-------------------------------------------------------
tc				.equ		0090h		; Timer C
tcl				.equ		tc			;       Low
tch				.equ		tc+1		;       High
;
;-------------------------------------------------------
;   External input enable register
;-------------------------------------------------------
inten			.equ		0096h
;
int0en			.btequ		0,inten		; INT0 input enable bit
int0pl			.btequ		1,inten		; INT0 input polarity select bit
;
;-------------------------------------------------------
;   Key input enable register
;-------------------------------------------------------
kien			.equ		0098h
ki0en			.btequ		0,kien		; KI0 input enable bit
ki0pl			.btequ		1,kien		; KI0 input polarity select bit
ki1en			.btequ		2,kien		; KI1 input enable bit
ki1pl			.btequ		3,kien		; KI1 input polarity select bit
ki2en			.btequ		4,kien		; KI2 input enable bit
ki2pl			.btequ		5,kien		; KI2 input polarity select bit
ki3en			.btequ		6,kien		; KI3 input enable bit
ki3pl			.btequ		7,kien		; KI3 input polarity select bit
;
;-------------------------------------------------------
;   Timer C control register0
;-------------------------------------------------------
tcc0			.equ		009ah
tcc00			.btequ		0,tcc0		; Timer C control bit
tcc01			.btequ		1,tcc0		; Timer C count source select bit
tcc02			.btequ		2,tcc0		;
tcc03			.btequ		3,tcc0		; INT3 interrupt and capture polarity select bit
tcc04			.btequ		4,tcc0		;
tcc06			.btequ		6,tcc0		; INT3 interrupt request generation timing select bit 
tcc07			.btequ		7,tcc0		; INT3 interrupt/capture input switching bit
;
;-------------------------------------------------------
;   Timer C control register1
;-------------------------------------------------------
tcc1			.equ		009bh
tcc10			.btequ		0,tcc1		; INT3 input filter select bit
tcc11			.btequ		1,tcc1		;
tcc12			.btequ		2,tcc1		; Timer C counter reload select bit
tcc13			.btequ		3,tcc1		; Compare0/capture select bit
tcc14			.btequ		4,tcc1		; Compare0 output mode select bit
tcc15			.btequ		5,tcc1		;
tcc16			.btequ		6,tcc1		; Compare1 output mode select bit
tcc17			.btequ		7,tcc1		;
;
;-------------------------------------------------------
;   Capture and compare0 register
;-------------------------------------------------------
tm0				.equ		009ch		; Capture and compare0 register
tm0l			.equ		tm0			;       Low
tm0h			.equ		tm0+1		;       High
;
;-------------------------------------------------------
;   Compare1 register
;-------------------------------------------------------
tm1				.equ		009eh		; Compare1 register
tm1l			.equ		tm1			;       Low
tm1h			.equ		tm1+1		;       High
;
;-------------------------------------------------------
;   UART0
;-------------------------------------------------------
u0mr			.equ		00a0h		; UART0 transmit/receive mode register
smd0_u0mr		.btequ		0,u0mr		; Serial I/O mode select bit
smd1_u0mr		.btequ		1,u0mr		;
smd2_u0mr		.btequ		2,u0mr		;
ckdir_u0mr		.btequ		3,u0mr		; Internal/external clock select bit
stps_u0mr		.btequ		4,u0mr		; Stop bit length select bit
pry_u0mr		.btequ		5,u0mr		; Odd/even parity select bit
prye_u0mr		.btequ		6,u0mr		; Parity enable bit
;
u0brg			.equ		00a1h		; UART0 bit rate generator ; Use "MOV" instruction when writing to this register.
;
u0tb			.equ		00a2h		; UART0 transmit buffer register ; Use "MOV" instruction when writing to this register.
u0tbl			.equ		u0tb		;       Low
u0tbh			.equ		u0tb+1		;       High
;
u0c0			.equ		00a4h		; UART0 transmit/receive control register0
clk0_u0c0		.btequ		0,u0c0		; BRG count source select bit
clk1_u0c0		.btequ		1,u0c0		;
txept_u0c0		.btequ		3,u0c0		; Transmit register empty flag
nch_u0c0		.btequ		5,u0c0		; Data output select bit
ckpol_u0c0		.btequ		6,u0c0		; CLK polarity select bit
uform_u0c0		.btequ		7,u0c0		; Transfer format select bit
;
u0c1			.equ		00a5h		; UART0 transmit/receive control register1
te_u0c1			.btequ		0,u0c1		; Transmit enable bit
ti_u0c1			.btequ		1,u0c1		; Transmit buffer empty flag
re_u0c1			.btequ		2,u0c1		; Receive enable bit
ri_u0c1			.btequ		3,u0c1		; Receive complete flag
;
u0rb			.equ		00a6h		; UART0 receive buffer register
u0rbl			.equ		u0rb        ;       Low
u0rbh			.equ		u0rb+1		;       High
oer_u0rb		.btequ		4,u0rbh		; Overrun error flag
fer_u0rb		.btequ		5,u0rbh		; Framing error flag
per_u0rb		.btequ		6,u0rbh		; Parity error flag
sum_u0rb		.btequ		7,u0rbh		; Error sum flag
;
ucon			.equ		00b0h		; UART transmit/receive control register2
u0irs			.btequ		0,ucon		; UART0 transmit interrupt cause select bit
u0rrm			.btequ		2,ucon		; UART0 continuous receive mode enable bit
cntrsel			.btequ		7,ucon		; Cntr0 pin select bit
;
;-------------------------------------------------------
;   SS control register H
;-------------------------------------------------------
sscrh			.equ		00b8h
;
cks0_sscrh		.btequ		0,sscrh		; Transfer clock rate select bit
cks1_sscrh		.btequ		1,sscrh		; 
cks2_sscrh		.btequ		2,sscrh		; 
mss_sscrh		.btequ		5,sscrh		; Master/Slave device select bit
rsstp_sscrh		.btequ		6,sscrh		; Receive single stop bit 
;
;-------------------------------------------------------
;   SS control register L
;-------------------------------------------------------
sscrl			.equ		00b9h
;
sres_sscrl		.btequ		1,sscrl		; SSUA control part reset bit
solp_sscrl		.btequ		4,sscrl		; SOL write protect bit
sol_sscrl		.btequ		5,sscrl		; Serial data output value setting bit
;
;-------------------------------------------------------
;   SS mode register 
;-------------------------------------------------------
ssmr			.equ		00bah
;
bc0_ssmr	    .btequ		0,ssmr		; Bit counter 2 to 0
bc1_ssmr		.btequ		1,ssmr		; 
bc2_ssmr		.btequ		2,ssmr		; 
cphs_ssmr		.btequ		5,ssmr		; SSCK clock phase select bit 
cpos_ssmr		.btequ		6,ssmr		; SSCK clock polarity select bit 
mls_ssmr		.btequ		7,ssmr		; MSB first/ LSB first select bit 
;
;-------------------------------------------------------
;   SS enable register 
;-------------------------------------------------------
sser			.equ		00bbh
;
ceie_sser		.btequ		0,sser		; Conflict error interrupt enable bit 
re_sser			.btequ		3,sser		; Receive enable bit 
te_sser			.btequ		4,sser		; Transmit enable bit
rie_sser		.btequ		5,sser		; Receive interrupt enable bit 
teie_sser		.btequ		6,sser		; Transmit end interrupt enable bit 
tie_sser		.btequ		7,sser		; Transmit interrupt enable bit 
;
;-------------------------------------------------------
;   SS status register 
;-------------------------------------------------------
sssr			.equ		00bch
;
ce_sssr  		.btequ		0,sssr		; Conflict error flag
orer_sssr		.btequ		2,sssr		; Overrun error flag
rdrf_sssr		.btequ		5,sssr		; Receive data register ful
tend_sssr		.btequ		6,sssr		; Transmit end
tdre_sssr		.btequ		7,sssr		; Transmit data empty
;
;-------------------------------------------------------
;   SS mode register 2
;-------------------------------------------------------
ssmr2			.equ		00bdh
;
ssums_ssmr2		.btequ		0,ssmr2		; SSUA mode select bit */
csos_ssmr2		.btequ		1,ssmr2		; SCS pin open drain output select bit */
soos_ssmr2		.btequ		2,ssmr2		; SSO pin open drain output select bit */
sckos_ssmr2		.btequ		3,ssmr2		; SSCK pin open drain output select bit */
css0_ssmr2		.btequ		4,ssmr2		; SCS pin selsct bit */
css1_ssmr2		.btequ		5,ssmr2		; SCS pin select bit */
scks_ssmr2		.btequ		6,ssmr2		; SSCK pin select bit */
bide_ssmr2		.btequ		7,ssmr2		; Bidirectional mode enable bit */
;
;-------------------------------------------------------
;   SS transmit data register
;-------------------------------------------------------
sstdr			.equ		00beh		;
;
;-------------------------------------------------------
;   SS receive data register
;-------------------------------------------------------
ssrdr			.equ		00bfh		;
;
;-------------------------------------------------------
;   A-D registers ADi
;-------------------------------------------------------
ad				.equ		00c0h		; A-D register
adl				.equ		ad			;       Low
adh				.equ		ad+1		;       High
;
;-------------------------------------------------------
;   A-D control register2
;-------------------------------------------------------
adcon2			.equ		00d4h		; A-D control register 2
smp				.btequ		0,adcon2	; A-D conversion method select bit
;
;-------------------------------------------------------
;   A-D control register0
;-------------------------------------------------------
adcon0			.equ		00d6h		; A-D control register0
;
ch0				.btequ		0,adcon0	; Analog input pin select bit
ch1				.btequ		1,adcon0	;
ch2				.btequ		2,adcon0	;
md				.btequ		3,adcon0	; A-D operation mode select bit
adgsel0			.btequ		4,adcon0	; A-D input group select bit
adcap			.btequ		5,adcon0	; A-D conversion automatic start bit 
adst			.btequ		6,adcon0	; A-D conversion start flag
cks0			.btequ		7,adcon0	; Frequency select bit0
cks0_adcon0 	.btequ		7,adcon0	; Frequency select bit0
;
;-------------------------------------------------------
;   A-D control register1
;-------------------------------------------------------
adcon1			.equ		00d7h		; A-D control register1
;
bits			.btequ		3,adcon1	; 8/10-bit mode select bit
cks1			.btequ		4,adcon1	; Frequency select bit1
cks1_adcon1 	.btequ		4,adcon1	; Frequency select bit1
vcut			.btequ		5,adcon1	; Vref connect bit
;
;-------------------------------------------------------
;	Port
;-------------------------------------------------------;
p1				.equ		00e1h		; Port P1
p1_0			.btequ		0,p1        ; Port P10 bit
p1_1			.btequ		1,p1        ; Port P11 bit
p1_2			.btequ		2,p1        ; Port P12 bit
p1_3			.btequ		3,p1        ; Port P13 bit
p1_4			.btequ		4,p1        ; Port P14 bit
p1_5			.btequ		5,p1        ; Port P15 bit
p1_6			.btequ		6,p1        ; Port P16 bit
p1_7			.btequ		7,p1        ; Port P17 bit
;
pd1				.equ		00e3h		; Port P0 direction register
pd1_0			.btequ		0,pd1       ; Port P00 direction bit
pd1_1			.btequ		1,pd1       ; Port P01 direction bit
pd1_2			.btequ		2,pd1       ; Port P02 direction bit
pd1_3			.btequ		3,pd1       ; Port P03 direction bit
pd1_4			.btequ		4,pd1       ; Port P04 direction bit
pd1_5			.btequ		5,pd1       ; Port P05 direction bit
pd1_6			.btequ		6,pd1       ; Port P06 direction bit
pd1_7			.btequ		7,pd1       ; Port P07 direction bit
;
p3				.equ		00e5h		; Port P3
p3_3			.btequ		3,p3        ; Port P33 bit
p3_4			.btequ		4,p3        ; Port P34 bit
p3_5			.btequ		5,p3        ; Port P35 bit
p3_7			.btequ		7,p3        ; Port P37 bit
;
pd3				.equ		00e7h		; Port P3 direction register
pd3_3			.btequ		3,pd3       ; Port P33 direction bit
pd3_4			.btequ		4,pd3       ; Port P34 direction bit
pd3_5			.btequ		5,pd3       ; Port P35 direction bit
pd3_7			.btequ		7,pd3       ; Port P37 direction bit 
;
p4				.equ		00e8h		; Port P4
p4_5			.btequ		5,p4        ; Port P45 bit
p4_6			.btequ		6,p4        ; Port P46 bit
p4_7			.btequ		7,p4        ; Port P47 bit
;
pd4				.equ		00eah		; Port P4 direction register
pd4_5			.btequ		5,pd4       ; Port P45 direction bit
;
;-------------------------------------------------------
;   Pull-up control registers
;-------------------------------------------------------
pur0			.equ		00fch		; Pull-up control register0
;
pu02			.btequ		2,pur0		; P10 to P13 pull-up
pu03			.btequ		3,pur0		; P14 to P17 pull-up
pu06			.btequ		6,pur0		; P30 to P33 pull-up
pu07			.btequ		7,pur0		; P37 pull-up
;
pur1			.equ		00fdh		; Pull-up control register1
;
pu11			.btequ		1,pur1		; P45 pull-up
;
;-------------------------------------------------------
;   Port P1 drive capacity control register
;-------------------------------------------------------
drr				.equ		00feh
;
drr0			.btequ		0,drr		; P10 drive capacity
drr1			.btequ		1,drr		; P11 drive capacity
drr2			.btequ		2,drr		; P12 drive capacity
drr3			.btequ		3,drr		; P13 drive capacity
drr4			.btequ		4,drr		; P14 drive capacity
drr5			.btequ		5,drr		; P15 drive capacity
drr6			.btequ		6,drr		; P16 drive capacity
drr7			.btequ		7,drr		; P17 drive capacity
;
;-------------------------------------------------------
;   Timer C output control register
;-------------------------------------------------------
tcout			.equ		00ffh
tcout0			.btequ		0,tcout		; CMP output enable bit0
tcout1			.btequ		1,tcout		; CMP output enable bit1
tcout2			.btequ		2,tcout		; CMP output enable bit2
tcout3			.btequ		3,tcout		; CMP output enable bit3
tcout4			.btequ		4,tcout		; CMP output enable bit4
tcout5			.btequ		5,tcout		; CMP output enable bit5
tcout6			.btequ		6,tcout		; CMP output reverse bit0
tcout7			.btequ		7,tcout		; CMP output reverse bit1
;
;------------------------------------------------------
;  Flash mamory control register4
;------------------------------------------------------
fmr4			.equ		01b3h
;
fmr40			.btequ		0,fmr4		; Erase-suspend function enable bit
fmr41			.btequ		1,fmr4		; Erase-suspend request bit
fmr46			.btequ		6,fmr4		; Read status flag
;
;------------------------------------------------------
;  Flash mamory control register1
;------------------------------------------------------
fmr1			.equ		01b5h
;
fmr11			.btequ		1,fmr1		; EW1 mode select bit
fmr15			.btequ		5,fmr1		; Block0 rewrite disable bit
fmr16			.btequ		6,fmr1		; Block1 rewrite disable bit
;
;------------------------------------------------------
;  Flash mamory control register0
;------------------------------------------------------
fmr0			.equ		01b7h
;
fmr00			.btequ		0,fmr0		;RY/BY status flag
fmr01			.btequ		1,fmr0		;CPU rewrite mode select bit
fmr02			.btequ		2,fmr0		;Block0 and 1 rewrite enable bit
fmrstp			.btequ		3,fmr0		;Flash memory stop bit
fmr06			.btequ		6,fmr0		;Program status flag
fmr07			.btequ		7,fmr0		;Erase status flag
;
